<?php
/**
 * Email Sending Function using SMTP
 * Configuration for smtpout.secureserver.net
 */

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php';

/**
 * Send email using SMTP configuration
 * 
 * @param string $to Recipient email address
 * @param string $subject Email subject
 * @param string $body Email body (HTML or plain text)
 * @param string $fromName Sender name (optional)
 * @param bool $isHTML Whether the body is HTML (default: true)
 * @return array Response with status and message
 */
if (!function_exists('sendEmail')) {
function sendEmail($to, $subject, $body, $fromName = 'Dextra Technologies', $isHTML = true) {
    // SMTP Configuration
    $config = [
        'host' => 'smtpout.secureserver.net',
        'port' => 465,
        'username' => 'info@dextratechnologies.com',
        'password' => 'Trickz2know@DXT',
        'encryption' => 'ssl',
        'from_email' => 'info@dextratechnologies.com',
        'from_name' => $fromName
    ];
    
    $mail = new PHPMailer(true);
    
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = $config['host'];
        $mail->SMTPAuth   = true;
        $mail->Username   = $config['username'];
        $mail->Password   = $config['password'];
        $mail->SMTPSecure = $config['encryption'];
        $mail->Port       = $config['port'];
        
        // Optional: Enable verbose debug output (comment out in production)
        // $mail->SMTPDebug = 2;
        
        // Recipients
        $mail->setFrom($config['from_email'], $config['from_name']);
        $mail->addAddress($to);
        
        // Content
        $mail->isHTML($isHTML);
        $mail->Subject = $subject;
        $mail->Body    = $body;
        
        if ($isHTML) {
            // Set plain text alternative for HTML emails
            $mail->AltBody = strip_tags($body);
        }
        
        // Send email
        $mail->send();
        
        return [
            'status' => 'success',
            'message' => 'Email sent successfully to ' . $to
        ];
        
    } catch (Exception $e) {
        return [
            'status' => 'error',
            'message' => 'Email could not be sent. Error: ' . $mail->ErrorInfo
        ];
    }
}
}

/**
 * Test email sending function
 * 
 * @param string $testEmail Email address to send test email to
 * @return array Response with status and message
 */
if (!function_exists('sendTestEmail')) {
function sendTestEmail($testEmail) {
    $subject = 'Test Email from SMTP Configuration';
    
    $body = '
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #4CAF50; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; background-color: #f9f9f9; }
            .footer { text-align: center; padding: 10px; font-size: 12px; color: #666; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>Test Email</h1>
            </div>
            <div class="content">
                <h2>SMTP Configuration Test</h2>
                <p>This is a test email sent from your SMTP configuration.</p>
                <p><strong>Configuration Details:</strong></p>
                <ul>
                    <li>SMTP Host: smtpout.secureserver.net</li>
                    <li>Port: 465</li>
                    <li>Encryption: SSL</li>
                    <li>From: info@dextratechnologies.com</li>
                </ul>
                <p>If you received this email, your SMTP configuration is working correctly!</p>
            </div>
            <div class="footer">
                <p>&copy; ' . date('Y') . ' Dextra Technologies. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>
    ';
    
    return sendEmail($testEmail, $subject, $body);
}
}

// Example usage (uncomment to test)
// $result = sendTestEmail('recipient@example.com');
// echo json_encode($result);
