# SMTP Email Test - Core PHP

A simple PHP email sending function using SMTP configuration for GoDaddy's secure server.

## Configuration

- **SMTP Host:** smtpout.secureserver.net
- **Port:** 465
- **Encryption:** SSL
- **Username:** info@dextratechnologies.com
- **Password:** Trickz2know@DXT

## Installation

1. Install PHPMailer using Composer:
```bash
composer install
```

## Files

- **send_email.php** - Core email sending functions
- **test.php** - Web interface to test email sending
- **composer.json** - Dependency management

## Usage

### Method 1: Web Interface

1. Navigate to `http://localhost/smtp-test/test.php`
2. Enter a recipient email address
3. Click "Send Test Email"

### Method 2: Direct Function Call

```php
<?php
require_once 'send_email.php';

// Send a test email
$result = sendTestEmail('recipient@example.com');
echo $result['message'];

// Send a custom email
$result = sendEmail(
    'recipient@example.com',
    'Subject Line',
    '<h1>Email Body</h1><p>This is HTML content</p>',
    'Sender Name',
    true // isHTML
);

if ($result['status'] === 'success') {
    echo "Email sent successfully!";
} else {
    echo "Error: " . $result['message'];
}
?>
```

## Functions

### `sendEmail($to, $subject, $body, $fromName, $isHTML)`

Send an email using SMTP configuration.

**Parameters:**
- `$to` (string) - Recipient email address
- `$subject` (string) - Email subject
- `$body` (string) - Email body (HTML or plain text)
- `$fromName` (string) - Sender name (default: 'Dextra Technologies')
- `$isHTML` (bool) - Whether the body is HTML (default: true)

**Returns:** Array with 'status' and 'message'

### `sendTestEmail($testEmail)`

Send a pre-formatted test email.

**Parameters:**
- `$testEmail` (string) - Email address to send test email to

**Returns:** Array with 'status' and 'message'

## Troubleshooting

If emails are not sending:

1. Verify SMTP credentials are correct
2. Check if port 465 is open on your server
3. Enable debug mode in `send_email.php` by uncommenting:
   ```php
   $mail->SMTPDebug = 2;
   ```
4. Check PHP error logs
5. Verify your email account allows SMTP access

## Security Notes

⚠️ **Important:** The password is currently hardcoded in the file. For production use:
- Move credentials to environment variables or a config file outside the web root
- Use `.env` files with proper permissions
- Never commit credentials to version control

## Requirements

- PHP 7.4 or higher
- Composer
- PHPMailer library
- XAMPP or similar PHP server
